;Copyright  1999  by Henter-Joyce, Inc.
;Script File for the MicroSoft Front Page Express
;written by J.C

Include "hjconst.jsh"
Include "hjglobal.jsh"
Include "fpxpress.jsh"
Include "fpxpress.jsm"

Function AutoStartEvent ()
var
  int IVerbosity
  let IVerbosity = GetVerbosity ()
If (FrontPageExpressFirstTime == 0) then
  let FrontPageExpressFirstTime = 1
If (IVerbosity == beginner) then
  Say (msg1, ot_help)
  Say (msg2, ot_help)
  Say (msg3, ot_help)
EndIf
EndIf 
EndFunction

Script ScriptFileName ()
  ScriptAndAppNames (msg4)
EndScript

Void Function FindString (handle WindowHandle, string Str, int Direction, int Restriction)
var
  int ICounter,
  int IColumn,
  int IRow
If ((GetControlID (WindowHandle) == tool_bar1 || GetControlID (WindowHandle) == tool_bar2) 
&& (GetWindowSubTypeCode (WindowHandle) == 0) && Restriction) then
  SaveCursor ()
  InvisibleCursor ()
  MoveToWindow (windowHandle)
  RestrictCursor (Off)
While ((GetCurrentWindow () == WindowHandle) && (ICounter < 20))    
If (GetWord () == Str) then
  let IColumn = GetCursorCol ()
  let IRow = GetCursorRow ()
  RestoreCursor ()
  JawsCursor ()
  MoveTo (IColumn, IRow)
  Return 1
EndIf
  NextWord ()
  let ICounter = ICounter + 1
EndWhile
  Return 0
Else 
  Return FindString (WindowHandle, Str, Direction, Restriction)
EndIf
EndFunction

Void Function IsToolBarList (handle WindowHandle)
If (GetWindowSubTypeCode (WindowHandle) == 0) then
If (GetWindowClass (GetAppMainWindow (WindowHandle)) == wc_jaws) then
If (GetWindowname (GetRealWindow (Windowhandle)) == ToolBarDialogName)then
  Return 1
EndIf
EndIf
EndIf
  Return 0
EndFunction

Void Function ClickToolBarButton (handle WindowHandle, string ButtonLabel)
  SaveCursor ()
  JawsCursor ()
  JawsPageUp ()
  JawsHome ()
If (FindGraphic(WindowHandle, ButtonLabel, s_top, s_unrestricted)) then
    Pause ()
  LeftMouseButton ()
Else
  Say (ButtonLabel + msg5, ot_message)
EndIf
EndFunction

HANDLE Function GetToolBar ()
var
  handle WindowHandle
  let WindowHandle = FindDescendantWindow (GetAppMainWindow (GetFocus ()), tool_bar1)
If (WindowHandle && GetWindowClass (WindowHandle) == wc_toolbar) then
  Return WindowHandle  
EndIf
  Return 0 
EndFunction

HANDLE Function GetToolBar2 ()
var
  handle WindowHandle 
  let WindowHandle = FindDescendantWindow (GetAppMainWindow (GetFocus ()), tool_bar2)
If (WindowHandle && GetWindowClass (WindowHandle) == wc_toolbar) then
  Return WindowHandle
EndIf
  Return 0
EndFunction

HANDLE Function GetToolBar3 ()
var
  handle WindowHandle 
  let WindowHandle = FindDescendantWindow (GetAppMainWindow (GetFocus ()), tool_bar3)
If (WindowHandle && GetWindowClass (WindowHandle) == wc_toolbar) then
  Return WindowHandle
EndIf
  Return 0
EndFunction

Int Function GetToolBarHandles (handle ByRef Handle1, handle ByRef Handle2, handle ByRef Handle3)
If (Handle1 && IsWindowVisible (Handle1) && Handle2 && IsWindowVisible (Handle2)
 && Handle3 && IsWindowVisible (Handle3)) then
  Return ToolBarAll
ElIf (Handle1 && IsWindowVisible (Handle1) && Handle2 && IsWindowVisible (handle2)) then
Return ToolBarOneTwo
ElIf (Handle1 && isWindowVisible (Handle1) && Handle3 && isWindowVisible (Handle3)) then
  return ToolBarOneThree
Elif (handle2 && isWindowVisible (Handle2) && handle3 && isWindowVisible (Handle3)) then
  Return toolBarTwoThree
ElIf (Handle1 && IsWindowVisible (Handle1)) then
  Return ToolBarOne
ElIf (Handle2 && IsWindowVisible (Handle2)) then
  Return ToolBarTwo
ElIf (handle3 && isWindowVisible (Handle3)) then
  Return ToolBarThree 
EndIf
  Return ToolBarNone  
EndFunction

Void Function ToolBarList ()
var 
  int Item, 
  int IToolBars
  let Item = 0
  let IToolBars = GetToolBarHandles (GetToolBar (), GetToolBar2 (), GetToolBar3 ())
If (! IToolBars) then
  Say (msg6, ot_message)
  Return
EndIf
If (IToolBars == ToolBarAll) then
  let Item = DLGSelectItemInList (ToolBarString1 + ToolBarString2 + ToolBarString3 + ToolBarString4, ToolBarDialogName, true)
Elif (IToolBars == ToolBarOneTwo) then
  let item = DLGSelectItemInList (ToolBarString1 + ToolBarString2 + ToolBarString3, ToolBarDialogName, true)
ElIf (iToolBars == ToolBarOneThree) then
  let item = DLGSelectItemInList (toolBarString1 + ToolBarString2 + toolBarString4, ToolBarDialogName, true)
If (item != 0 && item > offSet1) then
  Let item = item + OffSet3
EndIf
ElIf (iToolBars == toolBarTwoThree) then 
  let item = DLGSelectItemInList (ToolBarString3 + ToolBarString4, toolBarDialogName, true)
If (item != 0) then
  let item = item + OffSet1 
EndIf
ElIf (IToolBars == ToolBarOne) then
  let Item = DLGSelectItemInList (ToolBarString1 + ToolBarString2, ToolBarDialogName, true)
Elif (IToolBars == ToolBarTwo) then
  let Item = DLGSelectItemInList (ToolBarString3, ToolBarDialogName, true)
if (Item != 0) then
  let item = Item + OffSet1
EndIf
Elif (iToolBars == ToolBarThree) then
  let item = DLGSelectItemInList (ToolBarString4, ToolBarDialogName, true)
If (item != 0) then
  let item = item + OffSet2
EndIf 
EndIf
  let nSuppressEcho = true
  Delay (2)
If (Item == FileNew) then
  Pause ()
  ClickToolBarButton (getToolBar (), msg7)
ElIf (Item == FileOpen) then
  Pause ()
  ClickToolBarButton (GetToolBar (), msg8)
Elif (Item == FileSave) then
  Pause ()
  ClickToolBarButton (GetToolBar (), msg9)
ElIf (Item == FilePrint) then
  Pause ()
  ClickToolBarButton (GetToolBar (), msg10)
Elif (Item == printPreview) then
  Pause ()
  ClickToolBarButton (GetToolBar (), msg11)
ElIf (Item == Cut) then
  Pause ()
  ClickToolBarButton (GetToolBar (), msg12)
ElIf (Item == Copy) then
  Pause ()
  ClickToolBarButton (GetToolBar (), msg13)
Elif (Item == Paste) then
  Pause ()
  ClickToolBarButton (GetToolBar (), msg14)
ElIf (Item == Undo) then
  Pause ()
  ClickToolBarButton (GetToolBar (), msg15)
Elif (Item == Redo) then
  Pause ()
  ClickToolBarButton (GetToolBar (), msg16)
elIf (Item == WebBotComponent) then
  Pause ()
  ClickToolBarButton (GetToolBar (), msg17)
ElIf (Item == Table) then
  Pause ()
  ClickToolBarButton (GetToolBar (), msg18)
ElIf (Item == image) then
  Pause ()
  ClickToolBarButton (GetToolBar (), msg19)
ElIf (Item == Hyperlink) then
  Pause ()
  ClickToolBarButton (GetToolBar (), msg20)
ElIf (Item == Back) then
  Pause ()
  ClickToolBarButton (GetToolBar (), msg21)
Elif (Item == Forward) then
  Pause ()
  ClickToolBarButton (GetToolBar (), msg22)
Elif (Item == Refresh) then
  Pause ()
  ClickToolBarButton (getToolBar (), msg23)
elIf (Item == Stop) then
  Pause ()
  ClickToolBarButton (GetToolBar (), msg24)
ElIf (Item == ParagraphMarker) then
  Pause ()
  ClickToolBarButton (GetToolBar (), msg25)
elif (item == Help) then
  Pause ()
  ClickToolBarButton (GetToolBar (), msg26)
Elif (Item == DocumentFormat) then
  Pause ()
If (MoveToWindow (findDescendantWindow (GetAppMainWindow (GetFocus ()), cmbx_fontstyle))) then
  LeftMouseButton ()
  PcCursor ()
Else
  Say (msg46 + msg5, ot_message)
endIf  
ElIf (Item == FontType) then
  Pause ()
If (MoveToWindow (FindDescendantWindow (GetAppMainWindow (GetFocus ()), cmbx_fonttype))) then
  LeftMouseButton ()
  PcCursor ()
Else
  Say (msg47 + msg5, ot_message)
EndIf
ElIf (item == FontIncrease) then
  Pause ()
  ClickToolBarButton (GetToolBar2 (), msg27)
Elif (Item == FontDecrease) then
  Pause ()
  ClickToolBarButton (GetToolBar2 (), msg28)
Elif (item == Bold) then
  Pause ()
  ClickToolBarButton (GetToolBar2 (), msg29)
ElIf (Item == italics) then
  Pause ()
  ClickToolBarButton (GetToolBar2 (), msg30)
elif (item == Underline) then
  Pause ()
  ClickToolBarButton (GetToolBar2 (), msg31)
ElIf (Item == FontColor) then
  Pause ()
  ClickToolBarButton (GetToolBar2 (), msg32)
elIf (Item == AlignLeft) then
  Pause ()
  ClickToolBarButton (GetToolBar2 (), msg33)
ElIf (Item == AlignCenter) then
  Pause ()
  ClickToolBarButton (GetToolBar2 (), msg34)
ElIf (Item == alignRight) then
  Pause ()
  ClickToolBarButton (GetToolBar2 (), msg35)
ElIf (Item == ListNumbered) then
  Pause ()
  ClickToolBarButton (GetToolBar2 (), msg36)
elIf (Item == ListBulleted) then
  Pause ()
  ClickToolBarButton (GetToolBar2 (), msg37)
ElIf (item == indentDecrease) then
  Pause ()
  ClickToolBarButton (GetToolBar2 (), msg38)
ElIf (Item == IndentIncrease) then
  Pause ()
  ClickToolBarButton (GetToolBar2 (), msg39)
ElIf (Item == TextField) then
  Pause ()
  ClickToolBarButton (GetToolBar3 (), msg40)
ElIf (Item == ScrollingTextBox) then
  Pause ()
  ClickToolBarButton (GetToolBar3 (), msg41)
ElIf (Item == CheckBox) then
  Pause ()
  ClickToolBarButton (GetToolBar3 (), msg42)
ElIf (Item == RadioButton) then
  Pause ()
  ClickToolBarButton (GetToolBar3 (), msg43)
ElIf (Item == DropDownMenu) then
  Pause ()
  ClickToolBarButton (GetToolBar3 (), msg44)
ElIf (Item == PushButton) then
  Pause ()
  ClickToolBarButton (GetToolBar3 (), msg45)
endIf 
  let nSuppressEcho = false 
  Return Item
EndFunction

Script CallToolBar ()
  ToolBarList ()
EndScript

Function SayFocusedWindow ()
var
  int WindowSubTypeCode,
  int IControlID,
  string WindowClass,
  handle WindowHandle
  let WindowHandle = GetFocus ()
  let windowclass = GetWindowClass (WindowHandle)
  let IControlID = getControlID (WindowHandle)
  let WindowSubTypeCode = GetWindowSubTypeCode (WindowHandle)
If (WindowClass == wc_helpinformationwindow) then
If (GlobalMenuMode == menu_inactive) then
  SayWindow (WindowHandle, read_everything)
  Return
EndIf
EndIf
If (IControlID == edt_openfile) then
  Say (msg65, ot_control_name)
EndIf
  SayFocusedWindow ()
EndFunction

Function SayHighlightedText (handle WindowHandle, string Buffer)
var
  int WindowsubTypeCode
  let WindowSubTypeCode = GetWindowSubTypeCode (GetFocus ())
If (WindowSubTypeCode == wt_editcombobox) then
  Return
EndIf
  SayHighlightedText (WindowHandle, Buffer)
EndFunction

Function SayNonHighlightedText (handle WindowHandle, string Buffer)
var
    string WindowClass,
  handle Hwnd
  let Hwnd = GetFocus ()
If (nSuppressEcho) then
  Return
EndIf
  let WindowClass = GetWindowClass (WindowHandle)
If (WindowClass == wc_helpinformationwindow) then
If (GetWindowClass (Hwnd) == wc_helpinformationwindow) then
If (GlobalMenuMode == menu_inactive) then
  Say (Buffer, ot_buffer)
  Return
EndIf
EndIf
EndIf
  SayNonHighlightedText (WindowHandle, Buffer)
EndFunction

Script WindowKeysHelp ()
  Say (msg48, ot_help)
  Say (msg49, ot_help)
  Say (msg50, ot_help)
  Say (msg51, ot_help)
  Say (msg52, ot_help)  Say (msg53, ot_help)
  Say (msg54, ot_help)
  Say (msg55, ot_help)
  Say (msg56, ot_help)
  Say (msg57, ot_help)
  Say (msg58, ot_help)
  Say (msg59, ot_help)
  Say (msg60, ot_help)
  Say (msg61, ot_help)
  Say (msg62, ot_help)
  Say (msg63, ot_help)
  Say (msg64, ot_help)
EndScript

Script ReadCurrentScreen ()
var
  handle WindowHandle
  let WindowHandle = GetFocus ()
  MoveToWindow (WindowHandle)
  RestrictCursor (On)
  SayAll ()
EndScript

Script ReadNextScreen ()
  let nSuppressEcho = true
  PcCursor ()
  JawsPageDown ()
  Delay (2)
  let nSuppressEcho = false
  PerformScript ReadCurrentScreen ()  
EndScript

Script ReadPriorScreen ()
  let nSuppressEcho = true
  PcCursor ()
  jawsPageUP ()
  Delay (2)
  let nSuppressEcho = false
  PerformScript ReadCurrentScreen ()
EndScript

Script SayLine ()
var
  int IControlID
  let IControlID = GetControlID (GetFocus ())
If (IControlID == edt_openfile) then
  Say (msg65, ot_control_name)
endIf
  PerformScript sayLine ()
EndScript

Script SayWindowPromptAndText ()
var 
  int IControlID
  let IControlID = GetControlId (GetFocus ())
If (IControlID == edt_openfile) then
  Say (msg65, ot_control_name)
endIf
  PerformScript SayWindowPromptandText ()


EndScript

Script HotKeyHelp ()
  Say (msg66 + GetScriptKeyName ("CallToolBar"), ot_help)
  Say (msg67 , ot_help)
  Say (msg68, ot_help)
  Say (msg69, ot_help)
  say (msg70 + GetScriptKeyName ("ReadCurrentScreen"), ot_help)
  Say (msg71 + GetScriptKeyName ("ReadNextScreen"), ot_help)
  Say (msg72 + GetScriptKeyName ("ReadPriorScreen"), ot_help)  
EndScript

Script ScreenSensitiveHelp ()
var 
  int IControlID,
  handle WindowHandle,
  string WindowClass
If (IsSameScript ()) then
	AppFileTopic ()
	Return
EndIf
  let windowHandle = GetFocus ()
  let IControlID = GetControlID (WindowHandle)
  let WindowClass = GetWindowClass (WindowHandle)
If (IControlID == edt_maindocument && WindowClass == wc_maindocument) then
  Say (msg73, ot_help)
  say (msg74, ot_help)
  Say (msg75, ot_help)
  Return
endIf
If (WindowClass == wc_helpinformationwindow) then
  Say (msg76, ot_help)
  say (msg70, ot_help)
  Say (msg71, ot_help)
  Say (msg72, ot_help)
  Return
EndIf
  PerformScript ScreenSensitiveHelp ()
EndScript

Script ShowColorCoding ()
var
  handle WindowHandle
  let WindowHandle = FindDescendantWindow (GetTopLevelWindow (GetFocus ()), ckbx_showcolorcoding)
  {Alt + S}
  Pause ()
If (WindowHandle) then
  InvisibleCursor ()
  MoveToWindow (WindowHandle)
  PerformScript SayWord ()
EndIf
  PcCursor ()
EndScript
